/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.container;

import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.MountingHelper;
import java.util.ArrayList;
import org.apache.commons.lang3.mutable.MutableInt;

public class VerticalFlowLayout
extends FlowLayout {
    protected VerticalFlowLayout(Sizing horizontalSizing, Sizing verticalSizing) {
        super(horizontalSizing, verticalSizing);
    }

    @Override
    public void layout(Size space) {
        MutableInt layoutHeight = new MutableInt(0);
        MutableInt layoutWidth = new MutableInt(0);
        ArrayList layout = new ArrayList();
        Insets padding = (Insets)this.padding.get();
        Size childSpace = this.calculateChildSpace(space);
        MountingHelper mountState = MountingHelper.mountEarly((x$0, x$1, x$2) -> this.mountChild(x$0, x$1, x$2), this.children, childSpace, child -> {
            layout.add(child);
            child.inflate(childSpace);
            child.mount(this, this.x + padding.left() + ((Insets)child.margins().get()).left(), this.y + padding.top() + ((Insets)child.margins().get()).top() + layoutHeight.intValue());
            Size childSize = child.fullSize();
            layoutHeight.add(childSize.height() + this.gap);
            if (childSize.width() > layoutWidth.intValue()) {
                layoutWidth.setValue(childSize.width());
            }
        });
        layoutHeight.subtract(this.gap);
        this.contentSize = Size.of(layoutWidth.intValue(), layoutHeight.intValue());
        this.applySizing();
        if (this.horizontalAlignment() != HorizontalAlignment.LEFT) {
            for (Component component : layout) {
                component.updateX(component.x() + this.horizontalAlignment().align(component.fullSize().width(), this.width - padding.horizontal()));
            }
        }
        if (this.verticalAlignment() != VerticalAlignment.TOP) {
            for (Component component : layout) {
                if (this.verticalAlignment() == VerticalAlignment.CENTER) {
                    component.updateY(component.y() + (this.height - padding.vertical() - layoutHeight.intValue()) / 2);
                    continue;
                }
                component.updateY(component.y() + (this.height - padding.vertical() - layoutHeight.intValue()));
            }
        }
        mountState.mountLate();
    }
}

